/*
 * Decompiled with CFR 0.152.
 */
package cds.tools.pixtools;

import cds.healpix.CompassPoint;
import cds.healpix.FlatHashIterator;
import cds.healpix.Healpix;
import cds.healpix.HealpixNested;
import cds.healpix.HealpixNestedBMOC;
import cds.healpix.HealpixNestedFast;
import cds.healpix.HealpixNestedFixedRadiusConeComputer;
import cds.healpix.HealpixNestedPolygonComputer;
import cds.healpix.NeighbourList;
import cds.healpix.NeighbourSelector;
import cds.healpix.NestedEllipticalConeComputerApprox;
import cds.healpix.VerticesAndPathComputer;
import cds.moc.Range;
import cds.moc.SMoc;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;

public final class CDSHealpix {
    public static final int MAXORDER = 29;
    private static final int[] A = new int[]{3, 2, 0, 1};

    public static double[] pix2ang_nest(int order, long ipix) throws Exception {
        HealpixNested hn = Healpix.getNested(order);
        VerticesAndPathComputer vpc = hn.newVerticesAndPathComputer();
        double[] lonlat = vpc.center(ipix);
        double lat = lonlat[1];
        lonlat[1] = lonlat[0];
        lonlat[0] = 1.5707963267948966 - lat;
        return lonlat;
    }

    public static long ang2pix_nest(int order, double theta, double phi) throws Exception {
        double lonRad = phi;
        double latRad = 1.5707963267948966 - theta;
        HealpixNestedFast hc = Healpix.getNestedFast(order);
        return hc.hash(lonRad, latRad);
    }

    public static long[] query_disc(int order, double ra, double dec, double radius, boolean inclusive) throws Exception {
        HealpixNested hn = Healpix.getNested(order);
        HealpixNestedFixedRadiusConeComputer cp = hn.newConeComputer(radius);
        double[] coo = CDSHealpix.normalizeRaDec(ra, dec);
        HealpixNestedBMOC bmoc = null;
        try {
            bmoc = inclusive ? cp.overlappingCells(Math.toRadians(coo[0]), Math.toRadians(coo[1])) : cp.overlappingCenters(Math.toRadians(coo[0]), Math.toRadians(coo[1]));
        }
        catch (Exception e) {
            System.err.println("\nHEALPix.query_disc error: ra=" + ra + " dec=" + dec + " radius=" + radius + " (rad)");
            if (inclusive) {
                System.err.println("  Executing p.overlappingCells(+" + Math.toRadians(coo[0]) + ", " + Math.toRadians(coo[1]) + ")");
            } else {
                System.err.println("  Executing cp.overlappingCenters(" + Math.toRadians(coo[0]) + ", " + Math.toRadians(coo[1]) + ")");
            }
            e.printStackTrace();
        }
        return CDSHealpix.toFlatArrayOfHash(bmoc);
    }

    public static long[] query_discFXCenters(int order, double ra, double dec, double radius) throws Exception {
        HealpixNested hn = Healpix.getNested(order);
        HealpixNestedFixedRadiusConeComputer cp = hn.newConeComputer(radius);
        double[] coo = CDSHealpix.normalizeRaDec(ra, dec);
        HealpixNestedBMOC bmoc = cp.overlappingCenters(Math.toRadians(coo[0]), Math.toRadians(coo[1]));
        return CDSHealpix.toFlatArrayOfHash(bmoc);
    }

    public static SMoc getMocByCircle(int order, double ra, double dec, double radius, boolean inclusive) throws Exception {
        HealpixNested hn = Healpix.getNested(order);
        HealpixNestedFixedRadiusConeComputer cp = hn.newConeComputer(radius);
        double[] coo = CDSHealpix.normalizeRaDec(ra, dec);
        HealpixNestedBMOC bmoc = null;
        try {
            bmoc = inclusive ? cp.overlappingCells(Math.toRadians(coo[0]), Math.toRadians(coo[1])) : cp.overlappingCenters(Math.toRadians(coo[0]), Math.toRadians(coo[1]));
        }
        catch (Exception e) {
            System.err.println("\nHEALPix.query_disc error: ra=" + ra + " dec=" + dec + " radius=" + radius + " (rad)");
            if (inclusive) {
                System.err.println("  Executing p.overlappingCells(+" + Math.toRadians(coo[0]) + ", " + Math.toRadians(coo[1]) + ")");
            } else {
                System.err.println("  Executing cp.overlappingCenters(" + Math.toRadians(coo[0]) + ", " + Math.toRadians(coo[1]) + ")");
            }
            e.printStackTrace();
        }
        return CDSHealpix.bmoc2moc(bmoc, order);
    }

    static SMoc getMocByPolygon(int order, ArrayList<double[]> cooList, boolean inclusive) throws Exception {
        HealpixNested hn = Healpix.getNested(order);
        HealpixNestedPolygonComputer pc = hn.newPolygonComputer();
        double[][] vertices = new double[cooList.size()][2];
        cooList.toArray((T[])vertices);
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i][0] = Math.toRadians(vertices[i][0]);
            vertices[i][1] = Math.toRadians(vertices[i][1]);
        }
        HealpixNestedBMOC bmoc = inclusive ? pc.overlappingCells(vertices) : pc.overlappingCenters(vertices);
        return CDSHealpix.bmoc2moc(bmoc, order);
    }

    public static SMoc getMocByEllipse(int order, double ra, double dec, double a, double b, double pa) throws Exception {
        double aRad = Math.toRadians(a);
        double bRad = Math.toRadians(b);
        double paRad = Math.toRadians(pa);
        double lonRad = Math.toRadians(ra);
        double latRad = Math.toRadians(dec);
        NestedEllipticalConeComputerApprox cp = new NestedEllipticalConeComputerApprox(aRad, bRad, paRad, Healpix.getNested(order));
        HealpixNestedBMOC bmoc = cp.overlapping(lonRad, latRad, NestedEllipticalConeComputerApprox.Mode.OVERLAPPING_CELLS);
        return CDSHealpix.bmoc2moc(bmoc, order);
    }

    public static SMoc bmoc2moc(HealpixNestedBMOC bmoc, int order) throws Exception {
        int depthMax = 29;
        Range range = new Range();
        for (HealpixNestedBMOC.CurrentValueAccessor c : bmoc) {
            int depth = c.getDepth();
            int depthDiff = depthMax - depth;
            int twiceDepthDiff = depthDiff << 1;
            long hash = c.getHash();
            long a = hash << twiceDepthDiff;
            long b = a | (1L << twiceDepthDiff) - 1L;
            range.add(a, b + 1L);
        }
        SMoc moc = new SMoc(order);
        moc.setRangeList(range);
        return moc;
    }

    public static long[] query_polygon(int order, ArrayList<double[]> cooList, boolean inclusive) throws Exception {
        HealpixNested hn = Healpix.getNested(order);
        HealpixNestedPolygonComputer pc = hn.newPolygonComputer();
        double[][] vertices = new double[cooList.size()][2];
        cooList.toArray((T[])vertices);
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i][0] = Math.toRadians(vertices[i][0]);
            vertices[i][1] = Math.toRadians(vertices[i][1]);
        }
        HealpixNestedBMOC bmoc = inclusive ? pc.overlappingCells(vertices) : pc.overlappingCenters(vertices);
        long[] res = CDSHealpix.toFlatArrayOfHash(bmoc);
        return res;
    }

    private static final long[] toFlatArrayOfHash(HealpixNestedBMOC bmoc) {
        long nElems = bmoc.computeDeepSize();
        if (nElems > Integer.MAX_VALUE) {
            throw new Error("MOC contains too many elements!");
        }
        if (nElems < (long)bmoc.size()) {
            throw new Error("MOC deep size can't be < MOC size!");
        }
        long[] res = new long[(int)nElems];
        FlatHashIterator it = bmoc.flatHashIterator();
        int i = 0;
        while (it.hasNext()) {
            res[i] = it.next();
            ++i;
        }
        return res;
    }

    public static double[][] corners(int order, long npix) throws Exception {
        HealpixNested hn = Healpix.getNested(order);
        VerticesAndPathComputer vpc = hn.newVerticesAndPathComputer();
        EnumMap<CompassPoint.Cardinal, double[]> vertices = vpc.vertices(npix, EnumSet.allOf(CompassPoint.Cardinal.class));
        for (double[] v : vertices.values()) {
            v[0] = Math.toDegrees(v[0]);
            v[1] = Math.toDegrees(v[1]);
        }
        double[][] res = new double[vertices.size()][];
        res[0] = vertices.get((Object)CompassPoint.Cardinal.S);
        res[1] = vertices.get((Object)CompassPoint.Cardinal.E);
        res[2] = vertices.get((Object)CompassPoint.Cardinal.W);
        res[3] = vertices.get((Object)CompassPoint.Cardinal.N);
        return res;
    }

    public static double[][] borders(int order, long npix, int step) throws Exception {
        double[][] res;
        HealpixNested hn = Healpix.getNested(order);
        VerticesAndPathComputer vpc = hn.newVerticesAndPathComputer();
        for (double[] lonlatRad : res = vpc.pathAlongCellEdge(npix, CompassPoint.Cardinal.N, false, step)) {
            lonlatRad[0] = Math.toDegrees(lonlatRad[0]);
            lonlatRad[1] = Math.toDegrees(lonlatRad[1]);
        }
        return res;
    }

    public static long[] neighbours(int order, long npix) throws Exception {
        HealpixNested hn = Healpix.getNested(order);
        NeighbourSelector neig = hn.newNeighbourSelector();
        NeighbourList neigList = neig.neighbours(npix);
        long[] res = new long[]{neigList.get(CompassPoint.MainWind.SW), neigList.get(CompassPoint.MainWind.W), neigList.get(CompassPoint.MainWind.NW), neigList.get(CompassPoint.MainWind.N), neigList.get(CompassPoint.MainWind.NE), neigList.get(CompassPoint.MainWind.E), neigList.get(CompassPoint.MainWind.SE), neigList.get(CompassPoint.MainWind.S)};
        return res;
    }

    public static void main(String[] arg) {
        int order = 3;
        long max = 12L * CDSHealpix.pow2(order) * CDSHealpix.pow2(order);
        try {
            for (long npix = 0L; npix < max; ++npix) {
                long ring = CDSHealpix.nest2ring(order, npix);
                long nest = CDSHealpix.ring2nest(order, ring);
                if (nest == npix) continue;
                System.out.println("J'ai un gros souci pour order=" + order + "/" + npix + " => ring=" + ring + " nest=" + nest);
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static long nest2ring(int order, long npix) throws Exception {
        HealpixNested hn = Healpix.getNested(order);
        return hn.toRing(npix);
    }

    public static long ring2nest(int order, long npix) throws Exception {
        HealpixNested hn = Healpix.getNested(order);
        return hn.toNested(npix);
    }

    public static double pixRes(int order) {
        double res = 0.0;
        double degrad = Math.toDegrees(1.0);
        double skyArea = Math.PI * 4 * degrad * degrad;
        double arcSecArea = skyArea * 3600.0 * 3600.0;
        long nside = CDSHealpix.pow2(order);
        long npixels = 12L * nside * nside;
        res = arcSecArea / (double)npixels;
        res = Math.sqrt(res);
        return res;
    }

    static long nsidepix2uniq(long nside, long npix) {
        return 4L * nside * nside + npix;
    }

    static long[] uniq2nsidepix(long uniq) {
        return CDSHealpix.uniq2nsidepix(uniq, null);
    }

    static long[] uniq2nsidepix(long uniq, long[] nsidepix) {
        if (nsidepix == null) {
            nsidepix = new long[2];
        }
        long order = CDSHealpix.log2(uniq / 4L) / 2L;
        nsidepix[0] = CDSHealpix.pow2(order);
        nsidepix[1] = uniq - 4L * nsidepix[0] * nsidepix[0];
        return nsidepix;
    }

    public static final long pow2(long order) {
        return 1L << (int)order;
    }

    public static final long log2(long nside) {
        int i = 0;
        while (nside >>> ++i > 0L) {
        }
        return --i;
    }

    public static double[] radecToPolar(double[] radec) {
        return CDSHealpix.radecToPolar(radec, new double[2]);
    }

    public static double[] radecToPolar(double[] radec, double[] polar) {
        polar[0] = 1.5707963267948966 - radec[1] / 180.0 * Math.PI;
        polar[1] = radec[0] / 180.0 * Math.PI;
        return polar;
    }

    public static double[] polarToRadec(double[] polar) {
        return CDSHealpix.polarToRadec(polar, new double[2]);
    }

    public static double[] polarToRadec(double[] polar, double[] radec) {
        double dec = (1.5707963267948966 - polar[0]) * 180.0 / Math.PI;
        radec[0] = polar[1] * 180.0 / Math.PI;
        radec[1] = dec;
        return radec;
    }

    public static double[] normalizeRaDec(double ra, double dec) {
        if (dec < -90.0) {
            dec = 180.0 + dec;
            ra += 180.0;
        } else if (dec > 90.0) {
            dec = 180.0 - dec;
            ra += 180.0;
        }
        if (ra >= 360.0) {
            ra -= 360.0;
        } else if (ra < 0.0) {
            ra += 360.0;
        }
        return new double[]{ra, dec};
    }

    public static SMoc createSMoc(ArrayList<double[]> radecList, int order) throws Exception {
        return CDSHealpix.createSMoc(radecList, order, true);
    }

    public static SMoc createSMoc(ArrayList<double[]> radecList, int order, boolean inclusive) throws Exception {
        return CDSHealpix.getMocByPolygon(order, radecList, inclusive);
    }
}

